#!/bin/bash

# URL file yang ingin diunduh
FILE_URL="http://192.168.1.11/Fan_Arm_HG680p_HITAM.zip"
# Nama file untuk disimpan
FILE_NAME="Fan_Arm_HG680p_HITAM.zip"
# Nama file yang akan dipindahkan dari etc_init.d
FAN_CONTROL_FILE="fan_control"
# Direktori tujuan
INITD_DEST="/etc/init.d"
SYSTEMD_DEST="/etc/systemd/system"
BIN_DEST="/usr/bin"
# Direktori sementara
TEMP_DIR="Fan_Arm_HG680p_HITAM"

# Array untuk menyimpan nama file dari etc_systemd_system
SYSTEMD_FILES=("fan_control.service" "gpio_export.service") # Ganti dengan nama file yang sesuai

# Mengecek apakah file sudah ada
if [ -f "$FILE_NAME" ]; then
    echo "File '$FILE_NAME' sudah ada. Mengunduh ulang..."
else
    echo "File '$FILE_NAME' tidak ditemukan. Mengunduh..."
fi

# Mengunduh file
wget "$FILE_URL" -O "$FILE_NAME"

# Mengecek status unduhan
if [ $? -eq 0 ]; then
    echo "Unduhan '$FILE_NAME' berhasil!"

    # Mengecek apakah unzip terinstal
    if [ ! -x "$(command -v unzip)" ]; then
        echo "Unzip tidak terinstal. Silakan instal unzip."
        exit 1
    fi

    # Mengekstrak file
    unzip "$FILE_NAME"

    # Mengecek status ekstraksi
    if [ $? -eq 0 ]; then
        echo "Ekstraksi '$FILE_NAME' berhasil!"
        
        # Memindahkan file 'fan_control' ke '/etc/init.d'
        if [ -f "$TEMP_DIR/etc_init.d/$FAN_CONTROL_FILE" ]; then
            echo "Memindahkan '$FAN_CONTROL_FILE' ke '$INITD_DEST'..."
            sudo mv "$TEMP_DIR/etc_init.d/$FAN_CONTROL_FILE" "$INITD_DEST/"
            # Mengatur izin menjadi 755
            echo "Mengatur izin menjadi 755 untuk $FAN_CONTROL_FILE..."
            sudo chmod 755 "$INITD_DEST/$FAN_CONTROL_FILE"
            echo "'$FAN_CONTROL_FILE' berhasil dipindahkan dan izin diatur."
        else
            echo "File '$FAN_CONTROL_FILE' tidak ditemukan di '$TEMP_DIR/etc_init.d'."
        fi
        
        # Memindahkan file dari 'etc_systemd_system' ke '/etc/systemd/system'
        for SYSTEMD_FILE in "${SYSTEMD_FILES[@]}"; do
            if [ -f "$TEMP_DIR/etc_systemd_system/$SYSTEMD_FILE" ]; then
                echo "Memindahkan '$SYSTEMD_FILE' ke '$SYSTEMD_DEST'..."
                sudo mv "$TEMP_DIR/etc_systemd_system/$SYSTEMD_FILE" "$SYSTEMD_DEST/"
                # Mengatur izin menjadi 755
                echo "Mengatur izin menjadi 755 untuk $SYSTEMD_FILE..."
                sudo chmod 755 "$SYSTEMD_DEST/$SYSTEMD_FILE"
                echo "'$SYSTEMD_FILE' berhasil dipindahkan dan izin diatur."
            else
                echo "File '$SYSTEMD_FILE' tidak ditemukan di '$TEMP_DIR/etc_systemd_system'."
            fi
        done

        # Memindahkan file 'fan_monitor' ke '/usr/bin'
        FAN_MONITOR_FILE="fan_monitor"
        if [ -f "$TEMP_DIR/usr_bin/$FAN_MONITOR_FILE" ]; then
            echo "Memindahkan '$FAN_MONITOR_FILE' ke '$BIN_DEST'..."
            sudo mv "$TEMP_DIR/usr_bin/$FAN_MONITOR_FILE" "$BIN_DEST/"
            # Mengatur izin menjadi 755
            echo "Mengatur izin menjadi 755 untuk $FAN_MONITOR_FILE..."
            sudo chmod 755 "$BIN_DEST/$FAN_MONITOR_FILE"
            echo "'$FAN_MONITOR_FILE' berhasil dipindahkan dan izin diatur."
        else
            echo "File '$FAN_MONITOR_FILE' tidak ditemukan di '$TEMP_DIR/usr_bin/'."
        fi

    else
        echo "Ekstraksi '$FILE_NAME' gagal."
    fi
else
    echo "Unduhan '$FILE_NAME' gagal."
fi